/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.util.ArrayList;
import java.util.List;
import org.autoplot.dom.DomNode;
import org.autoplot.state.VapScheme;
import org.w3c.dom.Element;

public abstract class AbstractVapScheme
implements VapScheme {
    List<String> unresolved = new ArrayList<String>();
    String packg = "org.autoplot.dom";

    AbstractVapScheme() {
    }

    @Override
    public Class getClass(String clasName) {
        Class<?> c;
        if (!clasName.contains(".")) {
            clasName = this.packg + "." + clasName;
        }
        try {
            c = Class.forName(clasName);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        return c;
    }

    @Override
    public String getName(Class clas) {
        String elementName = clas.getName();
        if (elementName.startsWith(this.packg + ".")) {
            elementName = elementName.substring(this.packg.length() + 1);
        }
        elementName = elementName.replaceAll("\\$", "\\_dollar_");
        return elementName;
    }

    @Override
    public void addUnresolvedProperty(Element element, DomNode node, Exception exception) {
        String name = element.getAttribute("name");
        if (name.length() == 0) {
            name = element.getNodeName();
        }
        String value = element.getAttribute("value");
        this.unresolved.add(node.getId() + "  name=" + name + " value=\"" + value + "\"  " + exception);
    }

    @Override
    public String describeUnresolved() {
        StringBuilder buf = new StringBuilder();
        for (String s : this.unresolved) {
            buf.append(s).append("\n");
        }
        return buf.toString();
    }
}

